// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 ViewProj:ViewProjection;
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 World:World;   
   float4x4 ViewInv:ViewInverse;
   float4x4 PrevViewProj;

//--------------
// un-tweaks
//--------------
   float2 ViewSize;
   float FogRange;
   float4 Position[32];
   float4 Color[32];
   float4 Angle1[32];
   float4 Angle2[32];
   float4 Angle3[32];

//--------------
// Textures
//--------------
   texture DepthTexture <string Name = "";>;	
   sampler DepthSampler=sampler_state 
      {
         Texture=<DepthTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
      {
         float4 Pos:POSITION;
         float2 Tex0:TEXCOORD0;
      };
   struct OutPut
      {
         float4 Pos:POSITION;
         float4 Project:TEXCOORD0;
         float3 Normals:TEXCOORD1;
         float3 ViewVec:TEXCOORD2;
         float2 Range:TEXCOORD4;
         float4 Color:COLOR0;
      };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
      {
         OutPut OUT;
         int Index=floor(IN.Tex0.x);
         float4 WorldPos=Position[Index];
         float4 AngRow1=Angle1[Index];
         float4 AngRow2=Angle2[Index];
         float4 AngRow3=Angle3[Index];
         float3x3 Rotate=float3x3(AngRow1.xyz,AngRow2.xyz,AngRow3.xyz);
         IN.Pos.z *=WorldPos.w;
         IN.Pos.xy=lerp(IN.Pos.xy*AngRow1.w,IN.Pos.xy*AngRow2.w,IN.Tex0.y);
         OUT.Normals=float3(IN.Pos.xy,(IN.Pos.z-WorldPos.w)*0.1);
         IN.Pos.y *=AngRow3.w;
         WorldPos.xyz +=mul(IN.Pos.xyz,Rotate).xyz;
         OUT.Pos=mul(float4(WorldPos.xyz,1.0),ViewProj);
         float4 PrevPos=mul(float4(WorldPos.xyz,1),PrevViewProj);
         OUT.Project=float4(PrevPos.x*0.5+0.5*PrevPos.w,0.5*PrevPos.w-PrevPos.y*0.5,(OUT.Pos.z*0.5)-25.0,PrevPos.w);
         OUT.Normals=mul(OUT.Normals,Rotate).xyz;
         OUT.ViewVec=ViewInv[3].xyz-WorldPos.xyz;
         OUT.Range=float2(WorldPos.w*0.5,1.0-IN.Tex0.y);
         OUT.Color=Color[Index];
         OUT.Color.xyz *=OUT.Color.w;
         OUT.Color.xyz *=saturate(exp(-((OUT.Pos.z*0.5)/FogRange)));
         return OUT;
      }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN)  : COLOR
      {
         float Depth=tex2D(DepthSampler,(IN.Project.xy/IN.Project.w)+ViewSize).w-IN.Project.z;
         float Volume=pow(abs(dot(normalize(IN.Normals),normalize(IN.ViewVec))),4.0);
         Volume *=pow(IN.Range.y,5.0)*saturate(length(IN.ViewVec)/IN.Range.x);
         return float4(IN.Color.xyz*saturate(Volume-0.025)*saturate(Depth/50.0),1.0);
      }

//--------------
// techniques   
//--------------
   technique LightVolume
      {
         pass p1
      {		
         vertexShader = compile vs_3_0 VS(); 
         pixelShader  = compile ps_3_0 PS();
         AlphaBlendEnable=true;
         SrcBlend=one;
         DestBlend=one;
         zwriteenable=false;
         ColorWriteEnable=7;
         CullMode=0;
      }
      }
